<?php

/*
 * This file is part of the Behat.
 * (c) Konstantin Kudryashov <ever.zet@gmail.com>
 *
 * For the full copyright and license information, please view the LICENSE
 * file that was distributed with this source code.
 */

namespace Behat\Testwork\EventDispatcher\Event;

use Behat\Testwork\Environment\Environment;
use Behat\Testwork\Specification\SpecificationIterator;
use Behat\Testwork\Tester\Setup\Setup;

/**
 * Represents an event right after a suite setup.
 *
 * @author Konstantin Kudryashov <ever.zet@gmail.com>
 */
final class AfterSuiteSetup extends SuiteTested implements AfterSetup
{
    /**
     * @var SpecificationIterator<mixed>
     */
    private $iterator;
    /**
     * @var Setup
     */
    private $setup;

    /**
     * Initializes event.
     *
     * @param Environment           $env
     * @param SpecificationIterator<mixed> $iterator
     * @param Setup                 $setup
     */
    public function __construct(Environment $env, SpecificationIterator $iterator, Setup $setup)
    {
        parent::__construct($env);

        $this->iterator = $iterator;
        $this->setup = $setup;
    }

    public function getSpecificationIterator()
    {
        return $this->iterator;
    }

    /**
     * Returns current test setup.
     *
     * @return Setup
     */
    public function getSetup()
    {
        return $this->setup;
    }
}
