# This is Rick Jerz's script to upgrade Moodle on his VPS server.
#   I could create a script to do everything in one step, but I prefer
#   to manually do the first two steps.
#
#
# In this script, I prep the new moodle with components from the "old"
#   moodle, then do a backup of the "current", rename the "current",
#   and then move the newly preped moodle into position.
# Perhaps this is somewhat like "GIT," but I can control the plugins, and
# 	 more specifically, some "code changes" a little better with this method.
#
# Revised:
# 5/9/2023: Initial script.
# 5/26/24: Added fix for removing courseindex.php using SED.
# 5/27/24: Revised to use SED instead of file copying.
# 11/21/25: Revised for Moodle 5.1.
#
# Requirements:
#   Download the new moodle to a temporary folder (mdupcodedir).
#   Uncompress it and rename it to the production moodle name (mdupcodename).
#   Run this script.
#
# Notes:
# The current Moodle is renamed to "moodle_old" as a precaution.

# clear
# Timer
((startup = SECONDS))

# Variables
# --------------------------------------------------
# Make sure to review these.

# www = web root (public_html, htdocs, docroot, etc.)
www=~/public_html # VPS
# Location of the Moodle code (i.e, the mooodle app)
mdl_code_folder=moodle5
# Folder where the new Moodle is prepared.
#temp_folder=~/mdl_temp # MAMP
temp_folder=~/mdl_temp # VPS
# If Moodle 5.0 or earlier, mdl_code_location="public_html". If Moodle 5.1, mdl_code_location="mdl_sites"
#mdl_code_location=~/mdl_sites # VPS and MAMP and future upgrades.
mdl_code_location=~/public_html # First transition to 5.1
# Important: Change to mdl_public_folder ("", for pre-5.1, "public" post 5.1)
# mdl_public_folder="public" # After Moodle 5.1 tansition
mdl_public_folder="" # First transition to 5.1
# The symbolic link file name in www.
link_file_name="moodle"
# Location of backup script and vars.txt file.
vars_folder=~/scripts # VPS
buscript="bu_m5-vs08.sh"
buscript_location="$vars_folder"/$buscript

# Today's Date
NOW=$(date +%F)

echo "------------------------------------------------------------------"
echo "Upgrade $mdl_code_folder in $mdl_code_location using $temp_folder/$mdl_code_folder."
echo "------------------------------------------------------------------"
echo "Today's date is: "$NOW
echo

# Verify that there is a new moodle folder ready to upgrade.
if [ ! -d $temp_folder/$mdl_code_folder ]; then
	echo $temp_folder/$mdl_code_folder" does not exist. Cannot continue!"
	echo
	exit
fi

# 2CopyConfig_php.sh
echo "Copy the old config.php file into the new moodle."
echo -------------------------------------------------
cp -p $mdl_code_location/$mdl_code_folder/config.php $temp_folder/$mdl_code_folder
echo "Show that config.php really made it."
ls -al $temp_folder/$mdl_code_folder/ | grep config.php
echo

# 3CopyPlugins.sh
# Make sure to edit these plugins
Number_of_PLUGINS="4"
PLUGIN1="mod/checklist"
PLUGIN2="course/format/topcoll"
PLUGIN3="blocks/sharing_cart"
PLUGIN4="blocks/configurable_reports"

# Copy Plugins
echo "Copy Plugins"
echo ------------
for i in $(seq 1 $Number_of_PLUGINS); do
	plugin_name="PLUGIN$i"
	cp -pR $mdl_code_location/$mdl_code_folder/$mdl_public_folder/${!plugin_name} $temp_folder/$mdl_code_folder/public/${!plugin_name}
	echo "$plugin_name"="${!plugin_name}"
done
echo

# 4CodeChanges.sh
echo "Code Changes"
echo "------------"
# Make the following "code" changes.
#   Note: You need to know what you are doing for code changes.
#
# Note: In MacOS, you need the '.bak' in the sed command.
#   Since a ".bak" file is created, I remove the .bak file.
#		In UNIX (vs08) I use a more standard form of the SED command.

# Modify Boost so that the home icon goes to a web page external to moodle.
#   A direct URL to edu-gen.com.
echo "Modify Boost navbar.mustache file with direct URL to homepage."
sed -i 's`{{{ config.homeurl }}}`https://www.edu-gen.com`' $temp_folder/$mdl_code_folder/public/theme/boost/templates/navbar.mustache

# Modify Boost to remove the courseindex block.
echo "Modify Boost drawers.php file to not display the courseindex."
sed -i "s/(get_user_preferences('drawer-open-index', true) == true)/false/" $temp_folder/$mdl_code_folder/public/theme/boost/layout/drawers.php
echo
# Done making code changes

# 5BackupMoodleNow.sh
# A backup script is needed before upgrading.
# If a backup is manually done, comment out the "source" line.
echo Backup the current Moodle Site
echo ------------------------------
echo "Enable maintenance mode"
php $mdl_code_location/$mdl_code_folder/admin/cli/maintenance.php --enable
echo
source "$buscript_location"
echo

# 6ReplaceOldMoodle.sh
echo Replace the old Moodle with the New $mdl_code_folder
echo -------------------------------------------
echo "Remove the previous "$mdl_code_folder"_old if it exists."
rm -rf $mdl_code_location/$mdl_code_folder"_old"

echo "Rename the old "$mdl_code_folder" to "$mdl_code_folder"_old."
mv -i $mdl_code_location/$mdl_code_folder $mdl_code_location/$mdl_code_folder"_old"

echo "Move the new moodle from $temp_folder into $mdl_code_location."
mv -i $temp_folder/$mdl_code_folder $mdl_code_location/$mdl_code_folder/
echo

echo "Show all moodle files and folders in $mdl_code_location."
ls -ald $mdl_code_location/moodle*
echo

# 7CreateSymbolicLin.sh
echo "Create the symbolic link file."
ln -fs $mdl_code_location/$mdl_code_folder/public $www/$link_file_name

echo "Replace $mdl_code_folder with $link_file_name in config.php."
sed -i "s|/$mdl_code_folder|/$link_file_name|" $mdl_code_location/$mdl_code_folder/config.php
echo

echo "Disable maintenance mode"
php $mdl_code_location/$mdl_code_folder/admin/cli/maintenance.php --disable
echo

# Purge caches
echo "Purge caches"
php $mdl_code_location/$mdl_code_folder/admin/cli/purge_caches.php
echo

# Finished
((end = SECONDS)) # Used for overall timing
((duration_sec = end - startup))
((duration_min = 1 + duration_sec / 60))
echo "*****************   Upgrade complete!   ***************** "
# Eventually, write this message to the log file.
echo $(date)": $mdl_code_folder updated."
echo "Total update duration = $duration_sec seconds. Under $duration_min minutes elapsed time for this process."
echo
