# Create a symbolic link file to /public within the new Moodle 5.1.
# Edit $CFG->wwwroot so that it uses the symbolic link file name, not the moodle folder name.
# Disable maintenance mode.

# Variables:
# www = web root (public_html, htdocs, docroot, etc.)
#www=~/htdocs # MAMP
www=~/public_html # VPS
# Location of the Moodle code (i.e, the mooodle app)
mdl_code_folder=moodle5 # VPS and MAMP
# Folder where the new Moodle is prepared.
#temp_folder=~/mdl_temp # MAMP
temp_folder=~/mdl_temp # VPS
# If Moodle 5.0 or earlier, mdl_code_location="public_html". If Moodle 5.1, mdl_code_location="mdl_sites"
#mdl_code_location=~/mdl_sites # VPS and MAMP and future upgrades.
mdl_code_location=~/public_html # First transition to 5.1
# Important: Change to mdl_public_folder ("", for pre-5.1, "public" post 5.1)
# mdl_public_folder="public" # After Moodle 5.1 tansition
mdl_public_folder="" # First transition to 5.1

# 7CreateSymbolicLin.sh
echo "Create the symbolic link file."
ln -fs $mdl_code_location/$mdl_code_folder/public $www/$link_file_name

echo "Replace $mdl_code_folder with $link_file_name in config.php."
sed -i "s|/$mdl_code_folder|/$link_file_name|" $mdl_code_location/$mdl_code_folder/config.php
echo

echo "Disable maintenance mode"
php $mdl_code_location/$mdl_code_folder/admin/cli/maintenance.php --disable
echo
