# Instead of deleting your current moodle, rename it (just in case).
# Then move the new prepped moodle into its location.
# Revised: 11/20/2025 - After Moodle 5.1

# Variables:
# www = web root (public_html, htdocs, docroot, etc.)
#www=~/htdocs # MAMP
www=~/public_html # VPS
# Location of the Moodle code (i.e, the mooodle app)
mdl_code_folder=moodle5 # VPS and MAMP
# Folder where the new Moodle is prepared.
#temp_folder=~/mdl_temp # MAMP
temp_folder=~/mdl_temp # VPS
# If Moodle 5.0 or earlier, mdl_code_location="public_html". If Moodle 5.1, mdl_code_location="mdl_sites"
#mdl_code_location=~/mdl_sites # VPS and MAMP and future upgrades.
mdl_code_location=~/public_html # First transition to 5.1
# Important: Change to mdl_public_folder ("", for pre-5.1, "public" post 5.1)
# mdl_public_folder="public" # After Moodle 5.1 tansition
mdl_public_folder="" # First transition to 5.1

echo "Move the new prepped $temp_folder/$mdl_code_folder into $mdl_code_location."
echo "Remove the previous "$mdl_code_folder"_old if it exists."
rm -rf $mdl_code_location/$mdl_code_folder"_old"

echo "Rename the old "$mdl_code_folder" to "$mdl_code_folder"_old."
mv -i $mdl_code_location/$mdl_code_folder $mdl_code_location/$mdl_code_folder"_old"

echo "Move the new moodle from $temp_folder into $mdl_code_location."
mv -i $temp_folder/$mdl_code_folder $mdl_code_location/$mdl_code_folder/
echo

echo "Show all moodle files and folders in $mdl_code_location."
ls -ald $mdl_code_location/moodle*
echo
