# Copies Additional Plugins
# Revised 11/16/2025 for Moodle 5.1

# Variables:
# www = web root (public_html, htdocs, docroot, etc.)
#www=~/htdocs # MAMP
www=~/public_html # VPS
# Location of the Moodle code (i.e, the mooodle app)
mdl_code_folder=moodle5 # VPS and MAMP
# Folder where the new Moodle is prepared.
#temp_folder=~/mdl_temp # MAMP
temp_folder=~/mdl_temp # VPS
# If Moodle 5.0 or earlier, mdl_code_location="public_html". If Moodle 5.1, mdl_code_location="mdl_sites"
#mdl_code_location=~/mdl_sites # VPS and MAMP and future upgrades.
mdl_code_location=~/public_html # First transition to 5.1
# Important: Change to mdl_public_folder ("", for pre-5.1, "public" post 5.1)
# mdl_public_folder="public" # After Moodle 5.1 tansition
mdl_public_folder="" # First transition to 5.1

Number_of_PLUGINS="4"
PLUGIN1="mod/checklist"
PLUGIN2="course/format/topcoll"
PLUGIN3="blocks/sharing_cart"
PLUGIN4="blocks/configurable_reports"

# Copy Plugins
echo "Copy Plugins"
for i in $(seq 1 $Number_of_PLUGINS); do
	plugin_name="PLUGIN$i"
	cp -pR $mdl_code_location/$mdl_code_folder/$mdl_public_folder/${!plugin_name} $temp_folder/$mdl_code_folder/public/${!plugin_name}
	echo "$plugin_name"="${!plugin_name}"
done
echo
