# Unpack and rename the latest Moodle 5.1 or later.
# Revised: 11/16/2025 - Added folder name variable.

# Variables.
mdl_code_folder=moodle5

# Unpack Moodle.
echo "Unpack Moodle"
tar -xzf moodle-latest-501.tgz

# Rename this to $mdl_folder_name.
echo "Rename moodle to $mdl_code_folder"
mv moodle $mdl_code_folder
echo

# Verify its version.
echo "This is the current release:"
fgrep '$release' $mdl_code_folder/public/version.php
echo
